<?php
// Portal Redirect Plugin
// By DennisTT - http://www.dennistt.net - Moddified by Mole
// Version 1.1.0

// This plugin (C) DennisTT 2010.  You may not redistribute this plugin without the permission from DennisTT.

if(!defined("IN_MYBB"))
{
	die("Direct initialization of this file is not allowed.<br /><br />Please make sure IN_MYBB is defined.");
}

// The information that shows up on the plugin manager
// Note that the name of the function before _info, _activate, _deactivate must be the same as the filename before the extension.
function portalredirect_info()
{
	global $lang;
	portalredirect_load_language();
	
	return array(
		"name"			=> $lang->portalredirect,
		"description"	=> $lang->portalredirect_desc,
		"website"		=> "http://www.mybb.com",
		"author"		=> "DennisTT; Moified by Mole",
		"authorsite"	=> "http://www.mybb.com.",
		"version"		=> "1.1.0",
		"guid"			  => "e68d61e1c1b2ad155d98464a90338aa1",
		"compatibility"   => "16*",
		
		// Soul custom info
		"codename" => 'portalredirect',
	);
}

// Helper function to load the language variables
function portalredirect_load_language()
{
	global $lang;
	if(!defined('DENNISTT_PORTALREDIRECT_LANG_LOADED'))
	{
		$lang->load('portalredirect', false, true);
		
		if(!isset($lang->portalredirect))
		{
			$lang->portalredirect = 'هاك تحويل الي المجلة';
			$lang->portalredirect_desc = ' يقوم بتحويل الزيارات التي تأتي الي الرئيسية للمجلة طبقا لكوكيز من لوحة تحكم الهاك';
			
		}
		
		define('DENNISTT_PORTALREDIRECT_LANG_LOADED', 1);
	}
}

// This function runs when the plugin is activated.
function portalredirect_activate()
{
	global $db;
	
	// Deactivate first to remove any existing settings
	portalredirect_deactivate();
	
	$info = portalredirect_info();
	$setting_group_array = array(
		'name' => str_replace(' ', '_', 'dennistt_'.strtolower($info['codename'])),
		'title' => "هاك تحويل الي المجلة",
		'description' => "اعدادات الهاك",
		'disporder' => 1,
		'isdefault' => 0,
		);
	$db->insert_query('settinggroups', $setting_group_array);
	$group = $db->insert_id();
	
	$settings = array(
		'portalredirect_url' => array('اسم الصفحة', 'الرابط الذي سيتم التحويل اليه', 'text', 'portal.php'),
		'portalredirect_timeout' => array('الكوكيظ', ', ضع عدد الكوكيز بالدقائق ', 'text', '1200'),
		);

	$i = 1;
	foreach($settings as $name => $sinfo)
	{
		$insert_array = array(
			'name' => $name,
			'title' => $sinfo[0],
			'description' => $sinfo[1],
			'optionscode' => $sinfo[2],
			'value' => $sinfo[3],
			'gid' => $group,
			'disporder' => $i,
			'isdefault' => 0
			);
		$db->insert_query("settings", $insert_array);
		$i++;
	}

	rebuild_settings();
}

// This function runs when the plugin is deactivated.
function portalredirect_deactivate()
{
	global $db;
	$info = portalredirect_info();
	$result = $db->query("SELECT gid FROM ".TABLE_PREFIX."settinggroups WHERE name = '".str_replace(' ', '_', 'dennistt_'.strtolower($info['codename']))."' LIMIT 1");
	$group = $db->fetch_array($result);
	
	if(!empty($group['gid']))
	{
		$db->query("DELETE FROM ".TABLE_PREFIX."settinggroups WHERE gid = $group[gid] LIMIT 1");
		$db->query("DELETE FROM ".TABLE_PREFIX."settings WHERE gid = $group[gid]");
		rebuildsettings();
	}
}

$plugins->add_hook("index_start", "portalredirect_indexrun");
function portalredirect_indexrun()
{
	global $mybb;
	if ((!isset($_COOKIE['viewedportal']) && !isset($mybb->input['noredirect'])) || isset($mybb->input['forceredirect'])) {
		header('Location: '.$mybb->settings['portalredirect_url']);
		exit;
	}
}

$plugins->add_hook("portal_start", "portalredirect_portalrun");
function portalredirect_portalrun()
{
	global $mybb;
	
	my_setcookie('viewedportal', true, $mybb->settings['portalredirect_timeout']*60);
}

// End of Plugin
?>